/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.combo;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ComboState {
    public static final ResourceKey<Registry<ComboState>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("slashblade", "combo_state"));
    private ResourceLocation motionLoc;
    private int start;
    private int end;
    private float speed;
    private boolean loop;
    public int timeout;
    private Function<LivingEntity, ResourceLocation> next;
    private Function<LivingEntity, ResourceLocation> nextOfTimeout;
    private Consumer<LivingEntity> holdAction;
    private Consumer<LivingEntity> tickAction;
    private BiConsumer<LivingEntity, LivingEntity> hitEffect;
    private Consumer<LivingEntity> clickAction;
    private BiFunction<LivingEntity, Integer, SlashArts.ArtsType> releaseAction;
    private boolean isAerial;
    private int priority;

    public ResourceLocation getMotionLoc() {
        return this.motionLoc;
    }

    public int getStartFrame() {
        return this.start;
    }

    public int getEndFrame() {
        return this.end;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean getLoop() {
        return this.loop;
    }

    public int getTimeoutMS() {
        return (int)(TimeValueHelper.getMSecFromFrames(Math.abs(this.getEndFrame() - this.getStartFrame())) / (double)this.getSpeed()) + this.timeout;
    }

    public void holdAction(LivingEntity user) {
        this.holdAction.accept(user);
    }

    public void tickAction(LivingEntity user) {
        this.tickAction.accept(user);
    }

    public void hitEffect(LivingEntity target, LivingEntity attacker) {
        this.hitEffect.accept(target, attacker);
    }

    public void clickAction(LivingEntity user) {
        this.clickAction.accept(user);
    }

    public SlashArts.ArtsType releaseAction(LivingEntity user, int elapsed) {
        return this.releaseAction.apply(user, elapsed);
    }

    public static ResourceLocation getRegistryKey(ComboState state) {
        return ComboStateRegistry.REGISTRY.get().getKey((Object)state);
    }

    private ComboState(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.speed = builder.speed;
        this.timeout = builder.timeout;
        this.loop = builder.loop;
        this.motionLoc = builder.motionLoc;
        this.next = builder.next;
        this.nextOfTimeout = builder.nextOfTimeout;
        this.holdAction = builder.holdAction;
        this.tickAction = builder.tickAction;
        this.hitEffect = builder.hitEffect;
        this.clickAction = builder.clickAction;
        this.releaseAction = builder.releaseAction;
        this.isAerial = builder.aerial;
        this.priority = builder.priority;
    }

    public ResourceLocation getNext(LivingEntity living) {
        return this.next.apply(living);
    }

    public ResourceLocation getNextOfTimeout(LivingEntity living) {
        return this.nextOfTimeout.apply(living);
    }

    @Nonnull
    public ComboState checkTimeOut(LivingEntity living, float msec) {
        return (float)this.getTimeoutMS() < msec ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(this.nextOfTimeout.apply(living)) : this;
    }

    public boolean isAerial() {
        return this.isAerial;
    }

    public int getPriority() {
        return this.priority;
    }

    public static SlashArts.ArtsType releaseActionQuickCharge(LivingEntity user, Integer elapsed) {
        int level = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)user);
        if (elapsed <= 3 + level) {
            AdvancementHelper.grantedIf(Enchantments.f_44976_, user);
            AdvancementHelper.grantCriterion(user, AdvancementHelper.ADVANCEMENT_QUICK_CHARGE);
            return SlashArts.ArtsType.Jackpot;
        }
        return SlashArts.ArtsType.Fail;
    }

    public static long getElapsed(LivingEntity livingEntity) {
        return livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getElapsedTime(livingEntity)).orElse(0L);
    }

    public static class Builder {
        private int priority = 1000;
        private int start;
        private int end;
        private float speed = 1.0f;
        private boolean loop = false;
        private int timeout = 0;
        private ResourceLocation motionLoc = DefaultResources.ExMotionLocation;
        private Function<LivingEntity, ResourceLocation> next = entity -> SlashBlade.prefix("none");
        private Function<LivingEntity, ResourceLocation> nextOfTimeout;
        private boolean aerial = false;
        private Consumer<LivingEntity> holdAction;
        private Consumer<LivingEntity> tickAction = ArrowReflector::doTicks;
        private BiConsumer<LivingEntity, LivingEntity> hitEffect;
        private Consumer<LivingEntity> clickAction;
        private BiFunction<LivingEntity, Integer, SlashArts.ArtsType> releaseAction = (u, e) -> SlashArts.ArtsType.Fail;

        private Builder() {
            this.holdAction = a -> {};
            this.hitEffect = (a, b) -> {};
            this.clickAction = user -> {};
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public ComboState build() {
            return new ComboState(this);
        }

        public Builder startAndEnd(int start, int end) {
            this.start = start;
            this.end = end;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder loop() {
            this.loop = true;
            return this;
        }

        public Builder aerial() {
            this.aerial = true;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder motionLoc(ResourceLocation motionLoc) {
            this.motionLoc = motionLoc;
            return this;
        }

        public Builder next(Function<LivingEntity, ResourceLocation> next) {
            this.next = next;
            return this;
        }

        public Builder nextOfTimeout(Function<LivingEntity, ResourceLocation> nextOfTimeout) {
            this.nextOfTimeout = nextOfTimeout;
            return this;
        }

        public Builder addHoldAction(Consumer<LivingEntity> holdAction) {
            this.holdAction = this.holdAction.andThen(holdAction);
            return this;
        }

        public Builder addTickAction(Consumer<LivingEntity> tickAction) {
            this.tickAction = this.tickAction.andThen(tickAction);
            return this;
        }

        public Builder addHitEffect(BiConsumer<LivingEntity, LivingEntity> hitEffect) {
            this.hitEffect = this.hitEffect.andThen(hitEffect);
            return this;
        }

        public Builder clickAction(Consumer<LivingEntity> clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public Builder releaseAction(BiFunction<LivingEntity, Integer, SlashArts.ArtsType> clickAction) {
            this.releaseAction = clickAction;
            return this;
        }
    }

    public static class TimeLineTickAction
    implements Consumer<LivingEntity> {
        long offset = -1L;
        Map<Integer, Consumer<LivingEntity>> timeLine = Maps.newHashMap();

        public static TimeLineTickActionBuilder getBuilder() {
            return new TimeLineTickActionBuilder();
        }

        TimeLineTickAction(Map<Integer, Consumer<LivingEntity>> timeLine) {
            this.timeLine.putAll(timeLine);
        }

        @Override
        public void accept(LivingEntity livingEntity) {
            long elapsed = ComboState.getElapsed(livingEntity);
            if (this.offset < 0L) {
                this.offset = elapsed;
            }
            Consumer<LivingEntity> action = this.timeLine.getOrDefault((int)(elapsed -= this.offset), this::defaultConsumer);
            action.accept(livingEntity);
        }

        void defaultConsumer(LivingEntity entityIn) {
        }

        public static class TimeLineTickActionBuilder {
            Map<Integer, Consumer<LivingEntity>> timeLine = Maps.newHashMap();

            public TimeLineTickActionBuilder put(int ticks, Consumer<LivingEntity> action) {
                this.timeLine.put(ticks, action);
                return this;
            }

            public TimeLineTickAction build() {
                return new TimeLineTickAction(this.timeLine);
            }
        }
    }

    public static class TimeoutNext
    implements Function<LivingEntity, ResourceLocation> {
        long timeout;
        Function<LivingEntity, ResourceLocation> next;

        public static TimeoutNext buildFromFrame(int timeoutFrame, Function<LivingEntity, ResourceLocation> next) {
            return new TimeoutNext((int)TimeValueHelper.getTicksFromFrames(timeoutFrame), next);
        }

        public TimeoutNext(long timeout, Function<LivingEntity, ResourceLocation> next) {
            this.timeout = timeout;
            this.next = next;
        }

        @Override
        public ResourceLocation apply(LivingEntity livingEntity) {
            long elapsed = ComboState.getElapsed(livingEntity);
            if (this.timeout <= elapsed) {
                return this.next.apply(livingEntity);
            }
            return livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getComboSeq()).orElse(SlashBlade.prefix("none"));
        }
    }
}

